//------------------------------------------//
// filter.cpp                               //
//------------------------------------------//

//must include this one
#include "filter.h"

//headers specific to this filter
#include <Alert.h>
#include "stdio.h"		//for strcpy
#include "stdlib.h"		//for atoi
#include "string.h"
#include "malloc.h"


//Constants used in filter configuration window
const char FILTER_NAME[] 		= "Negative";
const char WINDOW_TITLE[] 		= "Negative Configure";
const char AUTHOR_NAME[] 		= "Sean Long";
const char VERSION_NAME[] 		= "1.00";
const char DESCRIPTION_NAME[]	= "Negate the image.";

//BMessages for Configuration window (please start at B_SPECIFIERS_END+50)


//------------------------------------------
// Negative

//construcor
Filter::Filter( image_id id )
{
	mId			= id;
 	Author 		= NULL;
 	Version		= NULL;
 	Description = NULL;

	Author = new char[strlen(AUTHOR_NAME)+1];
	strcpy(Author,AUTHOR_NAME);
	
	Version = new char[strlen(VERSION_NAME)+1];
	strcpy(Version,VERSION_NAME);

	Description = new char[strlen(DESCRIPTION_NAME)+1];
	strcpy(Description,DESCRIPTION_NAME);
		
}

Filter::~Filter()
{
	if(Author)		delete Author;
	if(Version)		delete Version;
	if(Description)	delete Description;

}

void Filter::Configure()
{	
	(new BAlert(WINDOW_TITLE,"This filter does not have any options.", "Ok"))->Go();
}	

void Filter::Process(const BBitmap *src, BBitmap **dest)
{
	//the actual function that manipulates the bitmap		  
	if(src == NULL) return;
	
	BRect bounds = src->Bounds();
	color_space cs = src->ColorSpace();
	if (cs != B_RGB32 && cs != B_RGBA32) 
	{
		return;
	}
	
	*dest = new BBitmap(bounds,cs);	
	if (*dest == NULL) 
	{
		return;
	}


	long drows, dcols, srows, scols;
	unsigned long *spixptr, *spix1;
	unsigned char *dpixptr, *dpix;
	
	unsigned long slb, dlb;
	long i, j;
	unsigned char *a;

	srows = src->Bounds().IntegerHeight()+1;
	scols = src->Bounds().IntegerWidth()+1;
	drows = (*dest)->Bounds().IntegerHeight();
	dcols = (*dest)->Bounds().IntegerWidth();
		
	// Get values from image
	dpixptr = (unsigned char *)(*dest)->Bits();
	dpix = (unsigned char *)dpixptr;
	spixptr = (unsigned long *)src->Bits();
	slb = src->BytesPerRow()/ 4;
	dlb = (*dest)->BytesPerRow();
	

	//negate image
	for(i=0; i <= drows;i++)
	{
		spix1 = spixptr + i*slb;
		for (j =0; j <= dcols; j++)
		{		
			a = (unsigned char *)(spix1 + j);			
			dpix[0] = (unsigned char) (255.0 - (float)a[0]);
			dpix[1] = (unsigned char) (255.0 - (float)a[1]);
			dpix[2] = (unsigned char) (255.0 - (float)a[2]);
			dpix += 4;
		}		
		dpix = (dpixptr += dlb);
	}	

	
}
